<?php

namespace Allocine\DbzModelBundle\Internal\Converter;

use PommProject\Foundation\Converter\PgJson;
use PommProject\Foundation\Session\Session;

class Link extends PgJson
{
    /**
     * toPg
     *
     * @see ConverterInterface
     */
    public function toPg($data, $type, Session $session)
    {
        $this->checksContraint($data);

        return
            $data !== null
                ? sprintf("json '%s'", $this->jsonEncode($data))
                : sprintf("NULL::%s", $type)
            ;
    }

    /**
     * toPgStandardFormat
     *
     * @see ConverterInterface
     */
    public function toPgStandardFormat($data, $type, Session $session)
    {
        $this->checksContraint($data);

        return
            $data !== null
                ? $this->jsonEncode($data)
                : null
            ;
    }

    /**
     * @param array $data
     * @throws \PommProject\Foundation\Exception\ConverterException
     * @throws \RuntimeException
     */
    private function checksContraint(array $data)
    {
        if ((empty($data['url'])) && (empty($data['route']))) {
            throw new \RuntimeException(sprintf(
                'Invalid link [%s]',
                $this->jsonEncode($data)
            ));
        }

        if ((!empty($data['url'])) && (!empty($data['route']))) {
            throw new \RuntimeException(sprintf(
                'Invalid link [%s] - Cannot have "url" and "route" together.',
                $this->jsonEncode($data)
            ));
        }

        if ((!isset($data['title'])) || (!isset($data['new_window'])) || (!isset($data['obfuscate']))) {
            throw new \RuntimeException(sprintf(
                'Invalid link [%s] - Missing title or new_window or obfuscate.',
                $this->jsonEncode($data)
            ));
        }

        foreach ($data as $key => $value) {
            if (!in_array($key, ['url', 'route', 'route_params', 'title', 'new_window', 'obfuscate'])) {
                throw new \RuntimeException(sprintf(
                    'Invalid link [%s] - unknown key %s.',
                    $this->jsonEncode($data),
                    $key
                ));
            }
        }
    }
}
