<?php

namespace Allocine\DbzModelBundle\Domains;

class GlobalId
{
    /**
     * @var array
     */
    private $transformers = [
        [
            'properties' => ['brand'],
            'method' => 'replaceNullValue'
        ],
        [
            'properties' => ['schema', 'table', 'brand', 'id'],
            'method' => 'removeUnauthorizedCharacters'
        ],
    ];

    /**
     * @var string
     */
    private $schema;

    /**
     * @var string
     */
    private $table;

    /**
     * @var string
     */
    private $brand;

    /**
     * @var int
     */
    private $id;

    /**
     * GlobalId constructor.
     *
     * @param string $schema
     * @param string $table
     * @param null|string $brand
     * @param int $id
     */
    public function __construct(string $schema, string $table, ?string $brand, int $id)
    {
        $this->schema = $schema;
        $this->table = $table;
        $this->brand = $brand;
        $this->id = $id;

        $this->transformProperties();
    }

    /**
     * @return string
     */
    public function getSchema(): string
    {
        return $this->schema;
    }

    /**
     * @param string $schema
     *
     * @return GlobalId
     */
    public function setSchema(string $schema): GlobalId
    {
        $this->schema = $schema;

        return $this;
    }

    /**
     * @return string
     */
    public function getTable(): string
    {
        return $this->table;
    }

    /**
     * @param string $table
     *
     * @return GlobalId
     */
    public function setTable(string $table): GlobalId
    {
        $this->table = $table;

        return $this;
    }

    /**
     * @return string
     */
    public function getBrand(): string
    {
        return $this->brand;
    }

    /**
     * @param string $brand
     *
     * @return GlobalId
     */
    public function setBrand(string $brand): GlobalId
    {
        $this->brand = $brand;

        return $this;
    }

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @param int $id
     *
     * @return GlobalId
     */
    public function setId(int $id): GlobalId
    {
        $this->id = $id;

        return $this;
    }

    /**
     * @return string
     */
    public function __toString()
    {
        return implode('.', [$this->schema, $this->table, $this->brand, $this->id]);
    }

    /**
     * @return string[]
     */
    public function toArray()
    {
        return [$this->schema, $this->table, $this->brand, $this->id];
    }

    /**
     * Transform object's properties
     */
    private function transformProperties()
    {
        foreach ($this->transformers as $transformer) {
            foreach ($transformer['properties'] as $property) {
                $this->$property = $this->{$transformer['method']}($this->$property);
            }
        }
    }

    /**
     * @param $value
     *
     * @return string
     */
    private function replaceNullValue($value)
    {
        return $value ?? '_';
    }

    /**
     * @param $value
     *
     * @return null|string|string[]
     */
    private function removeUnauthorizedCharacters($value) {
        return preg_replace("/[^A-Za-z0-9_]/", '', $value);
    }
}
