<?php

namespace Allocine\DbzModelBundle\Model\Stats;

use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelInterface;
use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelTrait;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use PommProject\ModelManager\Model\Model;
use PommProject\ModelManager\Model\Projection;
use PommProject\ModelManager\Model\ModelTrait\WriteQueries;

use PommProject\Foundation\Where;

use Allocine\DbzModelBundle\Model\Stats\AutoStructure\BrandMovieMonth as BrandMovieMonthStructure;
use Allocine\DbzModelBundle\Model\Stats\BrandMovieMonth;

/**
 * BrandMovieMonthModel
 *
 * Model class for table brand_movie_month.
 *
 * @see Model
 */
class BrandMovieMonthModel extends Model implements BrandAwareModelInterface
{
    use WriteQueries;
    use ModelTrait;
    use BrandAwareModelTrait;

    /**
     * __construct()
     *
     * Model constructor
     *
     * @access public
     */
    public function __construct()
    {
        $this->structure = new BrandMovieMonthStructure;
        $this->flexible_entity_class = '\Allocine\DbzModelBundle\Model\Stats\BrandMovieMonth';
    }
}
