<?php

namespace Allocine\DbzModelBundle\Tests;

use Allocine\DbzModelBundle\Model\Movie\MovieModel;
use Symfony\Component\DependencyInjection\Exception\ServiceNotFoundException;

class ModelServicesTest extends WebTestCase
{
    /**
     * A service model can be injected in many ways.
     */
    public function testInjectedPrivateModel()
    {
        $kernel = static::bootKernel();

        // From a private alias into an ArrayObject public service
        $fake = $kernel->getContainer()->get('test.testable_services');
        $this->assertInstanceOf(MovieModel::class, $fake[0]);

        // From the fully qualified name of the service (class) into a public service
        $fake = $kernel->getContainer()->get('test.fake_service');
        $this->assertInstanceOf(MovieModel::class, $fake->getModel());

        // From the generated private alias into a public service
        $fake = $kernel->getContainer()->get('test.fake_service_with_alias');
        $this->assertInstanceOf(MovieModel::class, $fake->getModel());
    }

    /**
     * An alias of the base model service should not be accessible directy.
     */
    public function testAccessYmlModelFail()
    {
        $kernel = static::bootKernel();

        $this->expectException(ServiceNotFoundException::class);
        $kernel->getContainer()->get('test.movie_model.configured_alias');
    }
}
