<?php

namespace Allocine\DbzModelBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

class Configuration implements ConfigurationInterface
{
    /**
     * getConfigTreeBuilder.
     *
     * @see ConfigurationInterface
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('dbz_model');
        $rootNode
            ->children()
                ->scalarNode('service_prefix')->defaultValue('dbz.model')->end()
                ->arrayNode('backends')
                    ->prototype('array')
                        ->children()
                            ->scalarNode('dsn')->end()
                            ->enumNode('type')
                                ->values([ServiceHelper::BACKEND_MASTER, ServiceHelper::BACKEND_SLAVE])
                                ->isRequired()
                            ->end()
                            ->scalarNode('name')->end()
                        ->end()
                    ->end()
                ->end()
            ->end()
        ;

        return $treeBuilder;
    }
}
