<?php

namespace Allocine\DbzModelBundle\DependencyInjection\Compiler;

use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Definition;
use Symfony\Component\DependencyInjection\Loader\PhpFileLoader;

class ModelPass implements CompilerPassInterface
{
    private $relativePathToModel = '/../../';

    /**
     * Automatically register every models within Allocine\DbzModelBundle\Model directory as services.
     * Tagging them with pomm.model is mandatory to get the session injected.
     *
     * @param ContainerBuilder $container
     */
    public function process(ContainerBuilder $container)
    {
        $modelsLoader = new PhpFileLoader($container, new FileLocator(__DIR__.$this->relativePathToModel.'Model'));
        $definition = new Definition();

        $definition
            ->addTag('pomm.model')
            ->addTag($container->getParameter('dbz_model.service_prefix').'.replicated')
        ;

        $modelsLoader->registerClasses(
            $definition,
            'Allocine\\DbzModelBundle\\Model\\',
            '*/*Model*'
        );
    }
}
