<?php

namespace Allocine\DbzModelBundle\Tests\Type\Social\User\Data;

use Allocine\DbzModelBundle\Domains\Tag3D;
use Allocine\DbzModelBundle\Internal\Type\Social\User\Data\BadgeCollection;
use Allocine\DbzModelBundle\Tests\KernelTestCase;

class DataTest extends KernelTestCase
{
    public function testHasBadge()
    {
        $badgeCollection = new BadgeCollection([
            [
                'badge' => 'A.B.C',
                'created_at' => '2002-01-01',
            ],
            [
                'badge' => 'D.E.F',
                'created_at' => '2003-01-01',
            ],
        ]);

        $this->assertCount(2, $badgeCollection);
        $this->assertTrue($badgeCollection->hasBadge('A.B.C'));
        $this->assertTrue($badgeCollection->hasBadge('D.E.F'));
        $this->assertFalse($badgeCollection->hasBadge('A.E.F'));
    }

    public function testAddBadge(): void
    {
        $badgeCollection = new BadgeCollection([]);
        $badgeCollection->addBadge('A.B.C');

        $this->assertCount(1, $badgeCollection);
        $this->assertTrue($badgeCollection->hasBadge('A.B.C'));

        $badgeCollection->addBadge('A.B.C'); // duplicate
        $badgeCollection->addBadge('D.E.F');

        $this->assertCount(2, $badgeCollection);
    }

    public function testAddBadgeWithCreatedAt(): void
    {
        //given
        $badgeCollection = new BadgeCollection([]);
        $createdAt = new \DateTime('2002-01-01');

        //when
        $badgeCollection->addBadge('A.B.C', $createdAt);

        //then
        self::assertCount(1, $badgeCollection);
        self::assertTrue($badgeCollection->hasBadge('A.B.C'));
        self::assertSame($createdAt->format('c'), $badgeCollection[0]->created_at->format('c'));
    }

    public function testRemoveBadge()
    {
        $badgeCollection = new BadgeCollection([
            [
                'badge' => 'A.B.C',
                'created_at' => '2002-01-01',
            ],
        ]);

        $badgeCollection->removeBadge('X.Y.Z');

        $this->assertCount(1, $badgeCollection);
        $this->assertTrue($badgeCollection->hasBadge('A.B.C'));

        $badgeCollection->removeBadge('A.B.C');

        $this->assertCount(0, $badgeCollection);
        $this->assertFalse($badgeCollection->hasBadge('A.B.C'));
    }
}
