<?php

namespace Allocine\DbzModelBundle\Test\Pomm\Foundation\PreparedQuery;

use PommProject\Foundation\PreparedQuery\PreparedQuery as PreparedQueryBase;

class PreparedQuery extends PreparedQueryBase
{
    /**
     * Returns a hash for a given sql query.
     * This version is different from the original one to avoid the Pomm error "prepared statement "xxxxxxxxxxxxxxxxx" already exists" issue during tests, and is intended ONLY for test environment use.
     *
     * Here is the step-by-step flow of what is happening:
     *
     * 1/ Test Process Connects: Your PHPUnit test starts, creates a Pomm instance, and connects to the database. Your connection pooler (PgBouncer) gives it a real, persistent connection to PostgreSQL (let's call this connection Conn-A).
     * 2/ Test Process Prepares a Statement: Your test runs its first findWhere() query. Pomm sends PREPARE xyz AS SELECT ... over Conn-A. PostgreSQL caches this prepared statement on that specific connection.
     * 3/ Test Process Makes an HTTP Call: Your test now acts as a client and sends a request to your web application. The test process waits, leaving its database connection Conn-A idle in the pool.
     * 4/ Web Server Process Connects: The web server receives the request and starts a new PHP process to handle the mutation. This process needs a database connection and asks the pooler for one.
     * 5/ Pooler Reuses the Connection: Because PgBouncer is in transaction pooling mode, it sees the idle connection Conn-A and hands it to the web server process. It does not reset the connection's state, meaning the prepared statement xyz is still cached on it.
     * 6/ Web Server Prepares the Same Statement: Your mutation code, running in the web server process, executes the exact same findWhere() query. It tries to send the same PREPARE xyz AS SELECT ... command over the Conn-A it just received.
     * 7/ PostgreSQL Error: PostgreSQL receives this second PREPARE command on a connection where that statement name already exists and correctly throws the error: prepared statement "xyz" already exists.
     *
     * A better solution could be to set PgBouncer in session pooling mode during tests.
     */
    public static function getSignatureFor(string $sql): string
    {
        return md5($sql . uniqid('pomm', true));
    }
}
