<?php

namespace Allocine\DbzModelBundle\Model\Secure;

use Allocine\DbzModelBundle\Internal\Model\ElementModel;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use Allocine\DbzModelBundle\Model\Secure\AutoStructure\Token as TokenStructure;

/**
 * Model for the Token entity.
 */
class TokenModel extends ElementModel
{
    use ModelTrait;

    public function __construct()
    {
        $this->structure = new TokenStructure();
        $this->flexibleEntityClass = Token::class;
    }

    /**
     * Returns a Token by its uuid.
     *
     * @param string $uuid
     *
     * @return Token|null
     */
    public function findByUuid(string $uuid)
    {
        $iterator = $this
            ->findWhere('uuid = $*', [$uuid])
        ;

        if (!$iterator->isEmpty()) {
            return $iterator->current();
        }

        return null;
    }

    /**
     * Returns a Token by its raw string.
     *
     * @param string $token
     *
     * @return Token|null
     */
    public function findByToken(string $token)
    {
        $iterator = $this
            ->findWhere('token = $*', [$token])
        ;

        if (!$iterator->isEmpty()) {
            return $iterator->current();
        }

        return null;
    }

    /**
     * Returns a Token for a given gid_user.
     *
     * @param string      $userId
     * @param string|null $suffix
     *
     * @return \PommProject\ModelManager\Model\CollectionIterator|Token[]
     */
    public function findByUserId(string $userId, string $suffix = '')
    {
        $iterator = $this->findWhere('gid_user = $*', [$userId], $suffix);

        if (!$iterator->isEmpty()) {
            return $iterator->current();
        }

        return null;
    }
}
