<?php

namespace Allocine\DbzModelBundle\Model\Movie;

use Allocine\DbzModelBundle\Internal\Model\ElementModel;
use PommProject\ModelManager\Model\Model;
use Allocine\DbzModelBundle\Model\Movie\AutoStructure\MovieReleaseHasLocalCertificate as MovieReleaseHasLocalCertificateStructure;

/**
 * MovieReleaseHasLocalCertificateModel
 *
 * Model class for table movie_release_has_local_certificate.
 *
 * @see Model
 */
class MovieReleaseHasLocalCertificateModel extends ElementModel
{
    public function __construct()
    {
        $this->structure = new MovieReleaseHasLocalCertificateStructure;
        $this->flexibleEntityClass = MovieReleaseHasLocalCertificate::class;
    }

    public function deleteByReleaseIdAndLocalizationId(int $releaseId, int $localizationId): void
    {
        $this->deleteWhere("id_release = $* and id_localization = $*", [$releaseId, $localizationId]);
    }

}
