<?php

namespace Allocine\DbzModelBundle\Model\Brand;

use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelTrait;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use Allocine\DbzModelBundle\Model\Brand\AutoStructure\Person as PersonStructure;
use PommProject\ModelManager\Model\Model;
use PommProject\ModelManager\Model\ModelTrait\ReadQueries;

/**
 * PersonModel.
 *
 * Model class for table person.
 *
 * @see Model
 */
class PersonModel extends Model
{
    use ReadQueries;
    use ModelTrait;
    use BrandAwareModelTrait;

    /**
     * __construct().
     *
     * Model constructor
     */
    public function __construct()
    {
        $this->structure = new PersonStructure();
        $this->flexibleEntityClass = Person::class;
    }
}
