<?php

namespace Allocine\DbzModelBundle\Model\Brand\AutoStructure;

use PommProject\ModelManager\Model\RowStructure;

/**
 * BrandHasTheater.
 *
 * Structure class for relation brand.brand_has_theater.
 *
 * Class and fields comments are inspected from table and fields comments.
 * Just add comments in your database and they will appear here.
 *
 * @see http://www.postgresql.org/docs/9.0/static/sql-comment.html
 * @see RowStructure
 */
class BrandHasTheater extends RowStructure
{
    /**
     * __construct.
     *
     * Structure definition.
     */
    public function __construct()
    {
        $this
            ->setRelation('brand.brand_has_theater')
            ->setPrimaryKey(['code_theater', 'id_brand'])
            ->addField('active', 'bool')
            ->addField('created_at', 'timestamp')
            ->addField('id_created_by', 'int4')
            ->addField('updated_at', 'timestamp')
            ->addField('id_updated_by', 'int4')
            ->addField('origin', 'tool.origin')
            ->addField('data', 'generic.data_with_seo')
            ->addField('id_brand', 'bpchar')
            ->addField('code_theater', 'bpchar')
            ->addField('description', 'text')
        ;
    }

    /**
     * Override pg type for custom php type mapping
     *
     * @throws \PommProject\ModelManager\Exception\ModelException
     */
    public function getTypeFor(string $name): string
    {
        if (in_array($name, [ 'data' ])) {
            return 'jsonb';
        }
        return parent::getTypeFor($name);
    }

}
