<?php

namespace Allocine\DbzModelBundle\Model\Brand\AutoStructure;

use PommProject\ModelManager\Model\RowStructure;

/**
 * BrandHasMovie.
 *
 * Structure class for relation brand.brand_has_movie.
 *
 * Class and fields comments are inspected from table and fields comments.
 * Just add comments in your database and they will appear here.
 *
 * @see http://www.postgresql.org/docs/9.0/static/sql-comment.html
 * @see RowStructure
 */
class BrandHasMovie extends RowStructure
{
    /**
     * __construct.
     *
     * Structure definition.
     */
    public function __construct()
    {
        $this
            ->setRelation('brand.brand_has_movie')
            ->setPrimaryKey(['id_movie', 'id_brand'])
            ->addField('active', 'bool')
            ->addField('created_at', 'timestamp')
            ->addField('id_created_by', 'int4')
            ->addField('updated_at', 'timestamp')
            ->addField('id_updated_by', 'int4')
            ->addField('origin', 'tool.origin')
            ->addField('data', 'brand.brand_has_movie.data')
            ->addField('id_brand', 'bpchar')
            ->addField('id_movie', 'int8')
            ->addField('title', 'text')
            ->addField('synopsis', 'text')
            ->addField('synopsis_hash', 'bpchar')
            ->addField('synopsis_json', 'jsonb')
            ->addField('synopsis_short_json', 'jsonb')
            ->addField('synopsis_short', 'text')
            ->addField('id_poster', 'int8')
            ->addField('keywords', 'text')
        ;
    }

    /**
     * Override pg type for custom php type mapping
     *
     * @throws \PommProject\ModelManager\Exception\ModelException
     */
    public function getTypeFor(string $name): string
    {
        if (in_array($name, [ 'data' ])) {
            return 'jsonb';
        }
        return parent::getTypeFor($name);
    }

}
