<?php

namespace Allocine\DbzModelBundle\Internal\Type\Social\UserHasReview\Data;

use Allocine\Titania\Type\Base\ConstrainedObject;
use Allocine\Titania\Type\Configuration\ClassDefinition;
use Psr\Log\LoggerInterface;
use Psr\Log\NullLogger;

/**
 * Class Moderation
 * @package Allocine\DbzModelBundle\Internal\Type\Social\User\Data
 *
 * @property int id_reason
 * @property string reason
 * @property string message
 * @property \DateTime banned_until
 *
 */
class Moderation extends ConstrainedObject
{
    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * Constructor
     *
     * @param array $data
     * @param LoggerInterface|null $logger
     */
    public function __construct($data = null, LoggerInterface $logger = null)
    {
        $this->logger = $logger ?: new NullLogger();
        parent::__construct($data);
    }

    /**
     * @return array
     */
    public static function getAttributeDefinition()
    {
        return [
            'id_reason'=> null,
            'reason' => null,
            'message' => null,
            'banned_until' => null,
        ];
    }

    /**
     * @return array
     * @throws \Exception
     */
    public static function getAttributeClassDefinition()
    {
        return [
            'banned_until' => new ClassDefinition([
                'class' => \DateTime::class,
                'nullable' => true
            ]),
        ];
    }

    /**
     * @inheritDoc
     */
    public function setAttribute($name, $value)
    {
        if ('id_reason' === $name) {
            if (!Reason::isValidValue($value)) {
                $this->logger->warning("Unknown Netino reason ID encountered", [
                    'value' => $value,
                ]);
                $value = Reason::UNKNOWN_REASON;
            }
        }

        return parent::setAttribute($name, $value);
    }
}
