<?php

namespace Allocine\DbzModelBundle\Internal\Type\Brand\Theater;

use Allocine\DbzModelBundle\Internal\Converter\Origin;
use Allocine\DbzModelBundle\Internal\Type\Generic\Links;
use Allocine\DbzModelBundle\Internal\Type\Theater\Theater\Data as TheaterData;
use Allocine\DbzModelBundle\Internal\Type\Generic\Data\Seo;
use Allocine\DbzModelBundle\Internal\Type\Theater\Theater\Data\Executive;
use Allocine\DbzModelBundle\Internal\Type\Theater\Theater\Data\Info;
use Allocine\DbzModelBundle\Internal\Type\Theater\Theater\Data\Override;
use Allocine\Titania\Type\Configuration\ClassDefinition;

/**
 * @property Info $info
 * @property Executive $executive
 * @property Origin $showtime_source
 * @property \DateTime $founded_at
 * @property Links $links
 * @property Override $override
 * @property Seo $seo
 */
class Data extends TheaterData
{
    /**
     * @return array
     */
    public static function getAttributeDefinition(): array
    {
        return [
            'seo' => [],
        ];
    }

    /**
     * @return array
     * @throws \Exception
     */
    public static function getAttributeClassDefinition(): array
    {
        return [
            'seo' => new ClassDefinition([
                'class' =>  Seo::class,
            ]),
        ];
    }
}
