<?php

namespace Allocine\DbzModelBundle\Internal\Type\Brand\EntityFlag\Data;

use Allocine\DbzModelBundle\Internal\Type\Brand\EntityFlag\Data\Provider\Provider;
use Allocine\Titania\Type\Base\ConstrainedObject;
use Allocine\Titania\Type\Configuration\ClassDefinition;

class Release extends ConstrainedObject
{
    /**
     * @return array
     */
    public static function getAttributeDefinition()
    {
        return [
            'avod' => [],
            'svod' => [],
            'global' => false,
            'online' => false,
            'theater' => false,
            'physical' => false,
            'television' => false,
            'vod' => false,
            'vodest' => false,
            'global_without_date' => false,
            'provider' => [],
        ];
    }

    /**
     * @return array
     * @throws \Exception
     */
    public static function getAttributeClassDefinition()
    {
        return [
            'svod' => new ClassDefinition([
                'class' =>  Svod::class,
            ]),
            'provider' => new ClassDefinition([
                'class' =>  Provider::class,
            ]),
        ];
    }
}
