<?php

namespace Allocine\DbzModelBundle\Internal\Model;

use PommProject\ModelManager\Model\Model;
use PommProject\ModelManager\Model\RowStructure;

trait BrandAwareModelTrait
{
    /**
     * @var string
     */
    protected $brand;

    /**
     * @var Model[]
     */
    protected $brandedModels = [];

    /**
     * Returns a branded clone of the current model.
     *
     * The 'master' model will retain and 'cache' every branded models in order to avoid multiple instances of a cloned
     * model.
     *

     * @param string $brand
     *
     * @return Model
     * @throws \Exception
     */
    public function getBrandedModel(string $brand): Model
    {
        if (null !== $this->brand) {
            throw new \Exception('You cannot get a branded model from another one, please use the main model.');
        }

        $brand = strtolower($brand);

        if (array_key_exists($brand, $this->brandedModels)) {
            return $this->brandedModels[$brand];
        }

        $model = clone $this;
        $model->brand = $brand;
        $model->structure->setRelation($this->structure->getRelation().'_'.$model->brand);

        $this->brandedModels[$model->brand] = $model;

        return $this->brandedModels[$model->brand];
    }

    public function __clone()
    {
        $this->structure = clone $this->structure;
        $this->brandedModels = [];
    }
}
