<?php

namespace Allocine\DbzModelBundle\Internal\Converter;

use PommProject\Foundation\Converter\ArrayTypeConverter;
use PommProject\Foundation\Session\Session;
use Allocine\DbzModelBundle\Domains\Tag3D as Tag3dDomain;

class Tag3D extends ArrayTypeConverter
{
    /**
     * @return array[]|false|mixed|null|string[]``
     */
    public function fromPg(?string $data, string $type, Session $session): mixed
    {
        $data = trim($data);

        if (is_null($data) || ($data === '')) {
            return null;
        }

        return new Tag3dDomain($data);
    }

    /**
     * @inheritDoc
     */
    public function toPg($data, string $type, Session $session): string
    {
        if (is_null($data)) {
            return sprintf("NULL::%s", $type);
        } else {
            $data = new Tag3dDomain($data);

            return sprintf("ltree '%s'", $data->__toString());
        }
    }

    /**
     * @inheritdoc
     */
    public function toPgStandardFormat($data, string $type, Session $session): ?string
    {
        if (is_null($data)) {
            return null;
        } else {
           return new Tag3dDomain($data);
        }
    }
}
