<?php

namespace Allocine\DbzModelBundle\Tests\Model;

use Allocine\DbzModelBundle\Model\News\NewsModel;
use Allocine\DbzModelBundle\Model\Social\UserModel;
use Allocine\DbzModelBundle\Tests\KernelTestCase;

class BrandAwareModelTest extends KernelTestCase
{
    public function testGetBrandedModel()
    {
        $brand = 'SC';
        $baseRelation = 'brand.news';

        /** @var NewsModel $baseModel */
        $baseModel = static::$container->get('test.testable_services')[4];

        /** @var UserModel $baseModel */
        $scModel = $baseModel->getBrandedModel($brand);
        $scModel->getStructure()->getRelation();

        // Assert that the structure are different objects to avoid any collision.
        $this->assertNotTrue($scModel->getStructure() === $baseModel->getStructure());
        // Assert that we are now using the right relation.
        $this->assertSame($baseRelation.'_'.strtolower($brand), $scModel->getStructure()->getRelation());
        // Assert that the base model relation has not been altered.
        $this->assertSame($baseRelation, $baseModel->getStructure()->getRelation());

        $errors = [];
        foreach ($scModel->findAll() as $element) {
            if ($element['id_brand'] !== $brand) {
                $errors[] = sprintf(
                    'Element with id #%s does not have the expected brand %s (found %s)',
                    $element[$scModel->getStructure()->getPrimaryKey()[0]],
                    $brand,
                    $element['id_brand']
                );
            }
        }

        if (empty($errors)) {
            $this->assertTrue(true);
        } else {
            $msg = sprintf("Found %s errors:\n", count($errors)).implode("\n", array_slice($errors, 0, 5));
            $this->fail($msg);
        }

        // Assert that branded model are well cached
        $anotherScModel = $baseModel->getBrandedModel($brand);
        $this->assertTrue(spl_object_hash($scModel) === spl_object_hash($anotherScModel));

        // Assert that a branded model is not retrieved from an already branded model.
        $this->expectException(\Exception::class);
        $scModel->getBrandedModel($brand);
    }
}
