<?php

namespace Allocine\DbzModelBundle\Tests\Type\Social\UserHasReview\Data;

use Allocine\DbzModelBundle\Internal\Type\Social\UserHasReview\Data\Moderation;
use Allocine\DbzModelBundle\Tests\KernelTestCase;

class ModerationTest extends KernelTestCase
{
    public function testConstructorIdReason()
    {
        $moderation = new Moderation([
            'id_reason' => 1,
        ]);

        $this->assertEquals(1, $moderation->id_reason);

        $this->expectException(\LogicException::class);
        $this->expectExceptionMessage(
            "Value 6 is not permited for Netino's id_reason."
        );

        $moderation = new Moderation([
            'id_reason' => 6,
        ]);
    }

    public function testSetIdReason()
    {
        foreach ([
            0,
            1,
            2,
            3,
            4,
            5,
            8,
            12,
            14,
            20,
            21,
            23,
            24,
            99,
            100,
            101,
            102,
            103,
            104,
            105,
            106,
            107,
            108,
            109,
        ] as $idReason)
        {
            $moderation = new Moderation();
            $moderation->id_reason = $idReason;

            $this->assertEquals($idReason, $moderation->id_reason);
        }

        /** Invalid reason */

        $moderation = new Moderation();

        $this->expectException(\LogicException::class);
        $this->expectExceptionMessage(
            "Value AAAA is not permited for Netino's id_reason."
        );

        $moderation->id_reason = 'AAAA';
    }

}
