<?php

namespace Allocine\DbzModelBundle\Model\Social;

use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelInterface;
use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelTrait;
use Allocine\DbzModelBundle\Internal\Model\ElementModel;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use Allocine\DbzModelBundle\Model\Social\AutoStructure\UserHasTheater as UserHasTheaterStructure;
use Allocine\DbzModelBundle\Model\Theater\Theater;
use PommProject\ModelManager\Model\Model;

/**
 * UserHasTheaterModel.
 *
 * Model class for table user_has_theater.
 *
 * @see Model
 */
class UserHasTheaterModel extends ElementModel implements BrandAwareModelInterface
{
    use ModelTrait;
    use BrandAwareModelTrait;

    const LEGACY_SAFE = true;

    /**
     * __construct().
     *
     * Model constructor
     */
    public function __construct()
    {
        $this->structure = new UserHasTheaterStructure();
        $this->flexible_entity_class = UserHasTheater::class;
    }

    /**
     * @param User $user
     * @return \Iterator
     */
    public function findAllTheatersByUser(User $user): \ArrayObject
    {
        $sql = <<<SQL
SELECT t.*, uhc.rank
FROM theater.theater t
INNER JOIN social.user_has_theater uhc
  ON uhc.code_theater = t.code
WHERE uhc.id_user = '{$user->id}'
AND uhc.id_brand = '{$user->id_brand}'
ORDER BY rank
SQL;

        $theaters = new \ArrayObject();

        foreach ($this->getSession()->getQueryManager()->query($sql) as $t) {
            $theaters->offsetSet($t['rank'], new Theater($t));
        }

        return $theaters;
    }

    /**
     * @param string $codeTheater
     * @param User $user
     * @return UserHasTheater|null
     * @throws \PommProject\ModelManager\Exception\ModelException
     */
    public function removeTheaterForUser(string $codeTheater, User $user) :
        ?UserHasTheater
    {

        $result  = $this->deleteByPK([
            'id_brand' => $user->id_brand,
            'id_user' => $user->id,
            'code_theater' => $codeTheater,
        ]);

        if (is_null($result)) {
            return null;
        }

        // Update ranks

        $sql = <<<SQL
WITH new_ranks AS (
  SELECT
    id_user,
    id_brand,
    code_theater,
    row_number() OVER (ORDER BY rank) AS new_rank
  FROM social.user_has_theater
  WHERE id_user = '{$user->id}'
  AND id_brand = '{$user->id_brand}'
)
UPDATE social.user_has_theater uhc
SET rank = new_rank
FROM new_ranks
WHERE uhc.id_brand = new_ranks.id_brand
AND uhc.id_user = new_ranks.id_user
AND uhc.code_theater = new_ranks.code_theater
SQL;

        $this
            ->getSession()
            ->getQueryManager()
            ->query($sql);

        return $result;
    }

    /**
     * @param User $user
     * @return int
     */
    public function countByUser(User $user) : int
    {
        return $this->countWhere(
            'id_user = $* AND id_brand = $*',
            [
                'id_user' => $user->id,
                'id_brand' => $user->id_brand,
            ]
        );
    }
}
