<?php

namespace Allocine\DbzModelBundle\Internal\Type\Social\UserHasReview\Data;

/**
 * Class Moderation
 * @package Allocine\DbzModelBundle\Internal\Type\Social\UserHasReview\Data
 *
 */
abstract class Reason
{
    /** @var int Valid Netino reason ids */

    const NON_PRECISE = 0;
    const DIFFAMATOIRE = 1;
    const AGRESSION = 2;
    const INSULTE = 3;
    const RACISME = 4;
    const ILLEGAL = 5;

    const SPAM = 8;

    const BLAGUES = 12;

    const ILLISIBLE = 14;

    const DOUBLON = 20;
    const PAS_ASSEZ_ARGUMENTE = 21;

    const HOMOPHOBIE = 23;
    const VULGARITE = 24;
    const DISCRIMINATION = 35;

    const AUTRE_MOTIF = 99;
    const SPOILER = 100;
    const ERREUR_NOTATION = 101;
    const DISGRESSION = 102;
    const HORS_SUJET = 103;
    const SUPPRESSION_CRITIQUE_FILM = 104;
    const SUPPRESSION_CRITIQUE_SERIE = 105;
    const CRITIQUE_SANS_AVOIR_VU = 106;
    const CRITIQUE_SANS_AVOIR_VU_ENTIER = 107;
    const CAPSLOCK = 108;
    const ERREUR_FICHE = 109;

    const REFUS_PETITE_SIRENE = 363;

    /**
     * @var array $constCacheArray
     */

    private static $constCacheArray = null;

    /**
     * @return mixed
     * @throws \ReflectionException
     */
    private static function getConstants() {
        if (self::$constCacheArray === null) {
            self::$constCacheArray = [];
        }

        $calledClass = get_called_class();

        if (! array_key_exists($calledClass, self::$constCacheArray)) {
            $reflect = new \ReflectionClass($calledClass);
            self::$constCacheArray[$calledClass] = $reflect->getConstants();
        }

        return self::$constCacheArray[$calledClass];
    }

    /**
     * @param $name
     * @param bool $strict
     * @return bool
     * @throws \ReflectionException
     */
    public static function isValidName($name, $strict = false) {
        $constants = self::getConstants();

        if ($strict) {
            return array_key_exists($name, $constants);
        }

        $keys = array_map('strtolower', array_keys($constants));

        return in_array(strtolower($name), $keys);
    }

    /**
     * @param $value
     * @return bool
     * @throws \ReflectionException
     */
    public static function isValidValue($value) {
        $values = array_values(self::getConstants());

        return in_array($value, $values, $strict = true);
    }

}
