<?php

namespace Allocine\DbzModelBundle\Internal\Type\Social\UserHasReview;

use Allocine\DbzModelBundle\Internal\Type\Social\UserHasReview\Data\Moderation;
use Allocine\Titania\Type\Base\ConstrainedObject;
use Allocine\Titania\Type\Configuration\ClassDefinition;

/**
 * Class Data
 * @package Allocine\DbzModelBundle\Internal\Type\Social\UserHasReview
 *
 * @property Moderation moderation
 */
class Data extends ConstrainedObject
{
    /**
     * @return array
     */
    public static function getAttributeDefinition()
    {
        return [
            'moderation' => null,
            'legacy_status' => null,
        ];
    }

    /**
     * @return array
     * @throws \Exception
     */
    public static function getAttributeClassDefinition()
    {
        return [
            'moderation' => new ClassDefinition([
                'class' => Moderation::class,
                'nullable' => true
            ]),
        ];
    }
}
