<?php

namespace Allocine\DbzModelBundle\Internal\Type\Social\UserHasRatingReview;

use Allocine\DbzModelBundle\Internal\Type\Generic\EmptyData;
use Allocine\DbzModelBundle\Internal\Type\Social\UserHasReview\Data
    as UserHasReviewData;
use Allocine\Titania\Type\Base\ConstrainedObject;
use Allocine\Titania\Type\Configuration\ClassDefinition;

/**
 * Class Data
 * @package Allocine\DbzModelBundle\Internal\Type\Social\UserHasRatingReview
 *
 * @property EmptyData rating
 * @property UserHasReviewData review
 */
class Data extends ConstrainedObject
{
    /**
     * @return array
     */
    public static function getAttributeDefinition()
    {
        return [
            'rating' => null,
            'review' => null,
        ];
    }

    /**
     * @return array
     * @throws \Exception
     */
    public static function getAttributeClassDefinition()
    {
        return [
            'rating' => new ClassDefinition([
                'class' => EmptyData::class,
                'nullable' => true
            ]),
            'review' => new ClassDefinition([
                'class' => UserHasReviewData::class,
                'nullable' => true
            ]),
        ];
    }
}
