<?php

namespace Allocine\DbzModelBundle\Internal\Type\Brand\EntityFlag;

use Allocine\DbzModelBundle\Internal\Type\Brand\EntityFlag\Data\Product;
use Allocine\DbzModelBundle\Internal\Type\Brand\EntityFlag\Data\Release;
use Allocine\DbzModelBundle\Internal\Type\Brand\EntityFlag\Data\Showtime;
use Allocine\DbzModelBundle\Internal\Type\Brand\EntityFlag\Data\SpecialOps;
use Allocine\DbzModelBundle\Internal\Type\Brand\EntityFlag\Data\Upcoming;
use Allocine\Titania\Type\Base\ConstrainedObject;
use Allocine\Titania\Type\Configuration\ClassDefinition;

class Flag extends ConstrainedObject
{
    /**
     * @return array
     */
    public static function getAttributeDefinition()
    {
        return [
            'product' => [],
            'release' => [],
            'showtime' => [],
            'upcoming' => [],
            'special_ops' => [],
        ];
    }

    /**
     * @return array
     * @throws \Exception
     */
    public static function getAttributeClassDefinition()
    {
        return [
            'product' => new ClassDefinition([
                'class' =>  Product::class,
            ]),
            'release' => new ClassDefinition([
                'class' =>  Release::class,
            ]),
            'showtime' => new ClassDefinition([
                'class' =>  Showtime::class,
            ]),
            'upcoming' => new ClassDefinition([
                'class' =>  Upcoming::class,
            ]),
            'special_ops' => new ClassDefinition([
                'class' =>  SpecialOps::class,
            ]),
        ];
    }
}
