<?php

namespace Allocine\DbzModelBundle\Internal\Type\Brand\Author;

use Allocine\DbzModelBundle\Internal\Type\Generic\Links;
use Allocine\DbzModelBundle\Internal\Type\Generic\Data\Seo;
use Allocine\Titania\Type\Base\ConstrainedObject;
use Allocine\Titania\Type\Configuration\ClassDefinition;

/**
 * @property Links $links
 * @property Seo $seo
 */
class Data extends ConstrainedObject
{
    /**
     * @return array
     */
    public static function getAttributeDefinition()
    {
        return [
            'links' => [],
            'seo' => [],
        ];
    }

    /**
     * @return array
     * @throws \Exception
     */
    public static function getAttributeClassDefinition()
    {
        return [
            'links' => new ClassDefinition([
                'class' =>  Links::class,
            ]),
            'seo' => new ClassDefinition([
                'class' =>  Seo::class,
            ]),
        ];
    }
}
