<?php

namespace Allocine\DbzModelBundle\Internal\Model;

use PommProject\ModelManager\Model\Projection;

trait ModelTrait
{
    /**
     * @param array $fields
     *
     * @return Projection
     */
    public function createProjection(array $fields = [])
    {
        if (empty($fields)) {
            return parent::createProjection();
        }

        $projection = new Projection($this->flexible_entity_class);
        foreach ($fields as $name => $field) {
            $projection->setField($name, ...$field);
        }

        return $projection;
    }
}
