<?php

namespace Allocine\DbzModelBundle\Internal\Converter;

use Allocine\DbzModelBundle\Domains\Tag3D as Tag3DDomain;
use Allocine\DbzModelBundle\Domains\Tag3DCollection;
use PommProject\Foundation\Converter\PgArray;
use PommProject\Foundation\Session\Session;

class Tag3DArray extends PgArray
{
    /**
     * getSubType.
     *
     * Extract subtype from a formatted string (ie int4[] or _text).
     *
     * @static
     *
     * @param string $type
     *
     * @return string
     */
    public static function getSubType($type)
    {
        return 'public.tag3d';
    }

    /**
     * @param $data
     * @param $type
     * @param Session $session
     *
     * @return array|mixed|null|void
     */
    public function fromPg($data, $type, Session $session)
    {
        $tag3DArray = parent::fromPg($data, $type, $session);

        return new Tag3DCollection($tag3DArray);
    }

    /**
     * @param $data
     * @param $type
     * @param Session $session
     *
     * @return array|mixed|null|void
     */
    public function toPgStandardFormat($data, $type, Session $session)
    {
        $tags = [];

        foreach ($data as $tag) {
            $tags[] = (new Tag3DDomain($tag))->toLtreeArray();
        }

        return parent::toPgStandardFormat($tags, $type, $session);
    }
}
