<?php

namespace Allocine\DbzModelBundle\Internal\Converter\Social\UserHasReview;

use PommProject\Foundation\Converter\ConverterInterface;
use PommProject\Foundation\Session\Session;
use Allocine\DbzModelBundle\Internal\Type\Social\UserHasReview\Stats as StatsType;

class Stats implements ConverterInterface
{
    /**
     * {@inheritdoc}
     */
    public function fromPg($data, $type, Session $session)
    {
        return new StatsType($data);
    }

    /**
     * {@inheritdoc}
     */
    public function toPg($data, $type, Session $session)
    {
        return sprintf(
            '%s::jsonb',
            $session->getConnection()->escapeLiteral($data->toJson())
        );
    }

    /**
     * {@inheritdoc}
     */
    public function toPgStandardFormat($data, $type, Session $session)
    {
        return sprintf(
            '%s::jsonb',
            $session->getConnection()->escapeLiteral($data->toJson())
        );
    }
}
