<?php

namespace Allocine\DbzModelBundle\Model\Stats;

use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelInterface;
use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelTrait;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use PommProject\ModelManager\Model\Model;
use PommProject\ModelManager\Model\Projection;
use PommProject\ModelManager\Model\ModelTrait\WriteQueries;

use PommProject\Foundation\Where;

use Allocine\DbzModelBundle\Model\Stats\AutoStructure\BrandTheaterAllTime as BrandTheaterAllTimeStructure;
use Allocine\DbzModelBundle\Model\Stats\BrandTheaterAllTime;

/**
 * BrandTheaterAllTimeModel
 *
 * Model class for table brand_theater_all_time.
 *
 * @see Model
 */
class BrandTheaterAllTimeModel extends Model implements BrandAwareModelInterface
{
    use WriteQueries;
    use ModelTrait;
    use BrandAwareModelTrait;

    /**
     * __construct()
     *
     * Model constructor
     *
     * @access public
     */
    public function __construct()
    {
        $this->structure = new BrandTheaterAllTimeStructure;
        $this->flexible_entity_class = '\Allocine\DbzModelBundle\Model\Stats\BrandTheaterAllTime';
    }
}
