<?php

namespace Allocine\DbzModelBundle\Model\Social;

use Allocine\DbzModelBundle\Common\Helper\OrderHelper;
use Allocine\DbzModelBundle\Common\Social\UserModelInterface;
use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelInterface;
use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelTrait;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use Allocine\DbzModelBundle\Model\Social\AutoStructure\User as UserStructure;
use PommProject\Foundation\Where;
use PommProject\ModelManager\Model\Model;
use PommProject\ModelManager\Model\ModelTrait\WriteQueries;

/**
 * UserModel.
 *
 * Model class for table user.
 *
 * @see Model
 */
class UserModel extends Model implements UserModelInterface, BrandAwareModelInterface
{
    use WriteQueries;
    use ModelTrait;
    use BrandAwareModelTrait;

    /**
     * __construct().
     *
     * Model constructor
     */
    public function __construct()
    {
        $this->structure = new UserStructure();
        $this->flexible_entity_class = '\Allocine\DbzModelBundle\Model\Social\User';
    }

    /**
     * @param string $email
     * @param string $idBrand
     *
     * @return null|User
     */
    public function loadByEmail(string $email, string $idBrand)
    {
        $field = $this->getStructure()->hasField('email_decrypted') ? 'email_decrypted' : 'email';
        $iterator = $this->findWhere(sprintf('%s = $* AND id_brand = $*', $field), [$email, $idBrand]);

        if (!$iterator->isEmpty()) {
            return $iterator->current();
        }

        return null;
    }

    /**
     * @param string $gid
     *
     * @return array|mixed|null
     */
    public function loadByGid(string $gid)
    {
        $iterator = $this->findWhere('gid = $*', [$gid]);

        if (!$iterator->isEmpty()) {
            return $iterator->current();
        }

        return null;
    }

    /**
     * @param array  $fields
     * @param string $suffix
     *
     * @return \PommProject\ModelManager\Model\CollectionIterator|User[]
     */
    public function findAllWhereIn(string $field, array $ids, array $fields = [], string $suffix = '')
    {
        $where = Where::createWhereIn($field, $ids);

        $connection = $this->getSession()->getConnection();

        $sql = strtr(
            "select {projection} from {relation} WHERE {where} ORDER BY {order} $suffix",
            [
                '{projection}' => $this->createProjection($fields),
                '{relation}' => $this->structure->getRelation(),
                '{where}' => $where,
                '{order}' => OrderHelper::buildFixedOrder($connection, $field, $ids),
            ]
        );

        return iterator_to_array($this->query($sql, $where->getValues()));
    }
}
