<?php

namespace Allocine\DbzModelBundle\DependencyInjection;

use PommProject\ModelManager\Model\Model;

class ServiceHelper
{
    const BACKEND_MASTER = 'master';
    const BACKEND_SLAVE = 'slave';

    /**
     * @param string      $class
     * @param string      $prefix
     * @param string|null $suffix
     *
     * @return string
     */
    public static function generateAliasForModel(string $class, string $prefix, string $suffix = null): string
    {
        $suffix = $suffix ? ".{$suffix}" : '';
        /** @var Model $model */
        $model = new $class();

        return sprintf(
            '%s.%s%s',
            $prefix,
            $model->getStructure()->getRelation(),
            $suffix
        );
    }

    /**
     * Search a session name with a given type (master by default) in a list of backends.
     * @param array  $backends
     * @param string $type
     *
     * @return string
     * @throws \Exception
     */
    public static function findSessionNameByType(array $backends, string $type = self::BACKEND_MASTER): string
    {
        ksort($backends);
        foreach ($backends as $backendId => $backendConfig) {
            if ($backendConfig['type'] == $type) {
                return $backendId;
            }
        }

        throw new \Exception(
            sprintf('Uname to find a backend with type [%s]', $type)
        );
    }
}
