<?php

namespace Allocine\DbzModelBundle\Model\News;

use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelInterface;
use Allocine\DbzModelBundle\Internal\Model\BrandAwareModelTrait;
use Allocine\DbzModelBundle\Internal\Model\ModelTrait;
use Allocine\DbzModelBundle\Model\News\AutoStructure\NewsHasEntity as NewsHasEntityStructure;
use PommProject\ModelManager\Model\Model;
use PommProject\ModelManager\Model\ModelTrait\WriteQueries;

/**
 * NewsHasEntityModel
 *
 * Model class for table news_has_entity.
 *
 * @see Model
 */
class NewsHasEntityModel extends Model implements BrandAwareModelInterface
{
    use WriteQueries;
    use ModelTrait;
    use BrandAwareModelTrait;

    /**
     * __construct()
     *
     * Model constructor
     */
    public function __construct()
    {
        $this->structure = new NewsHasEntityStructure();
        $this->flexible_entity_class = '\Allocine\DbzModelBundle\Model\News\NewsHasEntity';
    }
}
