<?php

namespace Allocine\DbzModelBundle\Model\Social;

use Allocine\DbzModelBundle\Crypto\SensitiveDataEncryptor;
use PommProject\ModelManager\Model\Model;
use PommProject\ModelManager\Model\ModelTrait\WriteQueries;

use PommProject\Foundation\Where;

use Allocine\DbzModelBundle\Model\Social\AutoStructure\User as UserStructure;

/**
 * UserModel
 *
 * Model class for table user.
 *
 * @see Model
 */
class UserModel extends Model
{
    use WriteQueries;

    /**
     * __construct()
     *
     * Model constructor
     *
     * @access public
     */
    public function __construct()
    {
        $this->structure = new UserStructure;
        $this->flexible_entity_class = '\Allocine\DbzModelBundle\Model\Social\User';
    }

    /**
     * As we are in model, email is crypted as in database
     * If you want request with encrypted email, use
     * Allocine\DbzModelBundle\Decorator\Social\DecryptedUserModelDecorator

     * @param string $cryptedEmail
     * @return null|User
     */
    public function loadByEmail(string $cryptedEmail)
    {
        $iterator = $this->findWhere("email = $*", [$cryptedEmail]);

        if (!$iterator->isEmpty()) {
            return $iterator->current();
        }

        return null;
    }
}
