<?php

namespace Allocine\DbzModelBundle\DependencyInjection;

use PommProject\ModelManager\Model\Model;

class ServiceHelper
{
    const BACKEND_MASTER = 'master';
    const BACKEND_SLAVE = 'slave';

    /**
     * @param string      $class
     * @param string      $prefix
     * @param string|null $suffix
     *
     * @return string
     */
    static public function generateAliasForModel(string $class, string $prefix, string $suffix = null): string
    {
        $suffix = $suffix ? ".{$suffix}" : '';
        /** @var Model $model */
        $model = new $class();

        return sprintf(
            '%s.%s%s',
            $prefix,
            $model->getStructure()->getRelation(),
            $suffix
        );
    }

    /**
     * @param array $backends
     *
     * @return string
     * @throws \Exception
     */
    static public function findFirstSlaveSessionServiceName(array $backends)
    {
        ksort($backends);
        foreach ($backends as $backendId => $backendConfig) {
            if ($backendConfig['type'] == self::BACKEND_MASTER) {
                $masterBackendName = $backendConfig['name'];
                break;
            }
        }

        if (!isset($masterBackendName)) {
            throw new \Exception('Unable to find a master backend.');
        }

        return "pomm.session.{$masterBackendName}.slave_1";
    }
}