<?php

namespace Allocine\DbzModelBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

class Configuration implements ConfigurationInterface
{
    /**
     * getConfigTreeBuilder.
     *
     * @see ConfigurationInterface
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('dbz_model');
        $rootNode
            ->children()
                ->scalarNode('service_prefix')->defaultValue('dbz.model')->end()
                ->scalarNode('query_logger')->end()
                ->scalarNode('sensitive_data_encryption_key')
                    ->isRequired()
                    ->info('This is the key used to decrypt sensitive data stored in dbz.')
                ->end()
                ->scalarNode('sensitive_data_encryption_algorithm')
                    ->isRequired()
                    ->info('This is the algorithm used to decrypt sensitive data stored in dbz.')
                ->end()
                ->arrayNode('backends')
                    ->prototype('array')
                        ->children()
                            ->scalarNode('dsn')->end()
                            ->enumNode('type')
                                ->values([ServiceHelper::BACKEND_MASTER, ServiceHelper::BACKEND_SLAVE])
                                ->isRequired()
                            ->end()
                            ->scalarNode('name')->end()
                        ->end()
                    ->end()
                ->end()
            ->end()
        ;

        return $treeBuilder;
    }
}
