<?php

namespace Allocine\DbzModelBundle\DependencyInjection\Compiler;

use Allocine\DbzModelBundle\DependencyInjection\ServiceHelper;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;

class SlaveModelPass implements CompilerPassInterface
{
    /**
     * Registers slave models to the slave session.
     *
     * @param ContainerBuilder $container
     *
     * @throws \Exception
     */
    public function process(ContainerBuilder $container)
    {
        $modelPrefix = $container->getParameter('dbz_model.service_prefix');
        $servicesIds = $container->findTaggedServiceIds($modelPrefix.'.replicated');

        $backends = $container->getExtensionConfig('dbz_model')[0]['backends'];
        $slaveSessionServiceId = ServiceHelper::findFirstSlaveSessionServiceName($backends);

        foreach ($servicesIds as $id => $tags) {
            $masterModelDefinition = $container->getDefinition($id);

            $alias = ServiceHelper::generateAliasForModel(
                $id,
                $modelPrefix,
                'slave'
            );

            $class = $masterModelDefinition->getClass();

            $container->register($alias, $class)
                ->setFactory([new Reference($slaveSessionServiceId), 'getModel'])
                ->addArgument($class)
            ;

            $alias = ServiceHelper::generateAliasForModel(
                $id,
                $modelPrefix,
                'slave'
            );

            $container->getDefinition('Allocine\DbzModelBundle\Internal\Core\ModelRegistry')
                ->addMethodCall('set', [$class, ['master_service_id' => $id, 'slave_service_id' => $alias]]);
        }
    }
}