<?php

namespace Allocine\DbzModelBundle\DependencyInjection\Compiler;

use Allocine\DbzModelBundle\DependencyInjection\ServiceHelper;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;

class ModelAliasesPass implements CompilerPassInterface
{
    /**
     * Add aliases for every model services, prefixed by parameter dbz_model.service_prefix (default: dbz.model).
     *
     * @param ContainerBuilder $container
     */
    public function process(ContainerBuilder $container)
    {
        $serviceIds = $container->findTaggedServiceIds('pomm.model');

        foreach ($serviceIds as $serviceId => $serviceConfig) {

            $alias = ServiceHelper::generateAliasForModel(
                $serviceId,
                $container->getParameter('dbz_model.service_prefix')
            );
            $container->setAlias($alias, $serviceId);
        }
    }

}
