<?php

namespace Allocine\DbzModelBundle\Decorator\Social;

use Allocine\DbzModelBundle\Crypto\SensitiveDataEncryptor;
use Allocine\DbzModelBundle\Model\Social\UserModel;

class DecryptedUserModelDecorator
{
    /**
     * @var SensitiveDataEncryptor
     */
    private $sensitiveDataEncryptor;

    /**
     * @var UserModel
     */
    private $userModel;

    /**
     * @param SensitiveDataEncryptor $sensitiveDataEncryptor
     * @param UserModel $userModel
     */
    public function __construct(SensitiveDataEncryptor $sensitiveDataEncryptor, UserModel $userModel)
    {
        $this->sensitiveDataEncryptor = $sensitiveDataEncryptor;
        $this->userModel = $userModel;
    }

    /**
     * Decorator to query database with UNCRYPTED email
     *
     * @param $email
     * @return User|null
     */
    public function loadByEmail(string $email)
    {
        $cryptedEmail = $this->sensitiveDataEncryptor->encrypt($email);

        return $this->userModel->loadByEmail($cryptedEmail);
    }

    /**
     * @param array $user
     * @return User
     */
    public function createAndSave(array $user)
    {
        if (!empty($user['email'])) {
            $user['email'] = $this->sensitiveDataEncryptor->encrypt($user['email']);
        }

        if (!empty($user['password'])) {
            $user['password'] = $this->sensitiveDataEncryptor->encrypt($user['password']);
        }

        if (!empty($user['salt'])) {
            $user['salt'] = $this->sensitiveDataEncryptor->encrypt($user['salt']);
        }
        if (!empty($user['profile'])) {
            $user['profile'] = $this->sensitiveDataEncryptor->encrypt($user['profile'], SensitiveDataEncryptor::FIELD_TYPE_JSON_STR, function ($item) {
                return $this->userModel->getSession()->getConnection()->escapeBytea($item);
            });
        }

        return $this->userModel->createAndSave($user);
    }
}
