# DBZ model bundle

This bundle provides an object representation of the [DBZ](https://github.com/allocine/dbz) database.

It uses the POMM project (see https://github.com/pomm-project/pomm-bundle).

**Important note regarding contributions**

This bundle is splitted from the [DBZ](https://github.com/allocine/dbz) repository to a read-only repository which be
used with composer.

The split occurs on:

- pull request: a branch with the same name as the origin branch (from the pull request) is created on the read-only 
repository.
- master merge: the master branch of the read-only repository is updated via Jenkins when a change is made on the
monorepository.     

## Installation

```
composer require allocine/dbz-model-bundle
``` 

## Development

### Workflow

1) Make the required changes.
2) Open a PR on `allocine/dbz`
3) Wait for your branch to be replicated on `allocine/dbz-model-bundle` repository **AND** on satis: https://satis.allocine.net/#allocine/dbz-model-bundle
4) Link your development to your project (Graph, www) by updating your composer.json like this:

    ```
    {
        require: {
		    "allocine/dbz-model-bundle": "dev-YOUR-PR-BRANCH-HERE"
        }
    }
    ```
5) Run `composer update allocine/dbz-model-bundle`. Your `composer.lock` should be something like this:
    ```
        {
            packages: [
                {
                    "name": "allocine/dbz-model-bundle",
                    "version": "dev-YOUR-PR-BRANCH-HERE",
                    "source": {
                        "type": "git",
                        "url": "git@github.com:allocine/dbz-model-bundle.git",
                        "reference": "ae3dd54417cb90d2078edada6ff82b998b6e3a67"
                    },
                    "dist": {
                        "type": "zip",
                        "url": "https://satis.allocine.net/dist/allocine/dbz-model-bundle/allocine-dbz-model-bundle-ae3dd54417cb90d2078edada6ff82b998b6e3a67-zip-bb3862.zip",
                        "reference": "ae3dd54417cb90d2078edada6ff82b998b6e3a67",
                        "shasum": "4fc3b22424c8b58e59b4e38e33e96aff4cf1e19e"
                    }
                }
            ]
        }
    ```
6) Make sure that satis is used.
7) Validate that everything is ok on the parent PR after commiting your `composer.lock`.
8) Merge your PR on `allocine/dbz`.
9) Wait the replication on `allocine/dbz-model-bundle`.
10) Tag `allocine/dbz-model-bundle` with something like v0.1.
11) Wait satis to be updated.
12) Update `composer.json` on the parent project:
    ```
    {
        require: {
            "allocine/dbz-model-bundle": "0.1"
        }
    }
    ```
13) Commit your parent project `composer.lock`
14) Update `php-packages/DbzModelBundle/composer.json` to increment the `dev-master` alias
    ```
      "extra": {
        "branch-alias": {
          "dev-master": "0.3.x-dev"
        }
      }
    ```
15) PR & merge.

Ex: if you tag with 0.2, then the alias should be `0.3.x-dev` so any side project using `allocine/dbz-model-bundle:0.3`
will get `dev-master`.

## Usage

### Documentation

* [More about Services](Resources/doc/Services.md)
* [Running tests](Resources/doc/Testing.md)

### Troubleshooting and hints

If you get this error when using composer:

```bash
  Problem 1
    - pomm-project/foundation 2.0.2 requires ext-pgsql * -> the requested PHP extension pgsql is missing from your system.
    - pomm-project/foundation 2.0.2 requires ext-pgsql * -> the requested PHP extension pgsql is missing from your system.
    - pomm-project/foundation 2.0.2 requires ext-pgsql * -> the requested PHP extension pgsql is missing from your system.
    - Installation request for pomm-project/foundation (locked at 2.0.2) -> satisfiable by pomm-project/foundation[2.0.2].
```

it's likely that you don't have a php installed with postgres support.

Make sure that you have *postgres support* enabled and not only the PDO driver (which is not the same).

If you're using the docker stack, then it should be already installed, if not, then check that you have the latested
image from the docker repository on GCP.

If you're using a local dev stack, then you must reinstall php with postgres support. If you're using homebrew:
`brew reinstall php71 --with-postgresql`
