<?php

namespace Allocine\DbzModelBundle\Tests\Model\Social;

use Allocine\DbzModelBundle\Decorator\Social\DecryptedUserModelDecorator;
use Allocine\DbzModelBundle\Tests\KernelTestCase;

class UserModelTest extends KernelTestCase
{
    /**
     * @todo use data-providers / fixtures
     *
     * @var array
     */
    private $users = [
        [
            'active' => true,
            'origin' => 'CORE',
            'id_brand' => 'AC',
            'id' => 23456789,
            'id_legacy' => 'Z23456789',
            'email' => 'john.smith@allocine.fr',
            'profile' => '{}',
            'password' => 'be',
            'salt' => 'er',
            'nickname' => 'John Smith'
        ],
        [
            'active' => true,
            'origin' => 'CORE',
            'id_brand' => 'AC',
            'id' => 234567892,
            'id_legacy' => 'Z22345678',
            'email' => 'lucky.luke@allocine.fr',
            'profile' => '{}',
            'password' => 'be',
            'salt' => 'er',
            'nickname' => 'Lucky Luke'
        ],
    ];

    protected function setUp()
    {
        parent::setUp();

        foreach ($this->users as $user) {
            $user = $this->getModel()->createAndSave($user, true);
        }
    }

    /**
     * @return DecryptedUserModelDecorator
     */
    private function getModel()
    {
        return static::$kernel->getContainer()->get('Allocine\DbzModelBundle\Decorator\Social\DecryptedUserModelDecorator');
    }

    public function testLoadByEmail()
    {
        $user = $this->getModel()->loadByEmail('lucky.luke@allocine.fr', 'AC');

        $this->assertNotNull($user);
        $this->assertSame($user['id'], 234567892);
    }
}
