<?php

namespace Allocine\DbzModelBundle\Model\Social;

use Allocine\DbzModelBundle\Common\Helper\OrderHelper;
use Allocine\DbzModelBundle\Common\Social\UserModelInterface;
use Allocine\DbzModelBundle\Model\Social\AutoStructure\User as UserStructure;
use PommProject\Foundation\Where;
use PommProject\ModelManager\Model\Model;
use PommProject\ModelManager\Model\ModelTrait\WriteQueries;
use PommProject\ModelManager\Model\Projection;

/**
 * UserModel
 *
 * Model class for table user.
 *
 * @see Model
 */
class UserModel extends Model implements UserModelInterface
{
    use WriteQueries;

    /**
     * __construct()
     *
     * Model constructor
     *
     * @access public
     */
    public function __construct()
    {
        $this->structure = new UserStructure;
        $this->flexible_entity_class = '\Allocine\DbzModelBundle\Model\Social\User';
    }

    /**
     * As we are in model, email is crypted as in database
     * If you want request with encrypted email, use
     * Allocine\DbzModelBundle\Decorator\Social\DecryptedUserModelDecorator

     * @param string $cryptedEmail
     * @param string $idBrand
     * @return null|User
     */
    public function loadByEmail(string $cryptedEmail, string $idBrand)
    {
        $iterator = $this->findWhere("email = $*::bytea AND id_brand = $*", [$cryptedEmail, $idBrand]);

        if (!$iterator->isEmpty()) {
            return $iterator->current();
        }

        return null;
    }

    /**
     * @param string $gid
     * @return array|mixed|null
     */
    public function loadByGid(string $gid)
    {
        $iterator = $this->findWhere("gid = $*", [$gid]);

        if (!$iterator->isEmpty()) {
            return $iterator->current();
        }

        return null;
    }

    /**
     * @param array $fields
     *
     * @return Projection
     */
    public function createProjection(array $fields = [])
    {
        if (empty($fields)) {
            return parent::createProjection();
        }

        $projection = parent::createProjection();
        foreach ($fields as $name => $field) {
            $projection->setField($name, ...$field);
        }

        return $projection;
    }

    /**
     * @param array  $fields
     * @param string $suffix
     *
     * @return \PommProject\ModelManager\Model\CollectionIterator|User[]
     */
    public function findAllWhereIn(string $field, array $ids, array $fields = [], string $suffix = '')
    {
        $where = Where::createWhereIn($field, $ids);

        $connection = $this->getSession()->getConnection();

        $sql = strtr(
            "select {projection} from {relation} WHERE {where} ORDER BY {order} $suffix",
            [
                '{projection}' => $this->createProjection($fields),
                '{relation}' => $this->structure->getRelation(),
                '{where}' => $where,
                '{order}' => OrderHelper::buildFixedOrder($connection, $field, $ids)
            ]
        );

        return $this->query($sql, $where->getValues());
    }
}
