<?php

namespace Allocine\DbzModelBundle\Internal\Core;

use Allocine\DbzModelBundle\Internal\Converter\Origin;
use Allocine\DbzModelBundle\Internal\Converter\Tag3D;
use Allocine\DbzModelBundle\Internal\Converter\Tag3DArray;
use PommProject\Foundation\Session\Session;
use PommProject\Foundation\Converter\ConverterHolder;
use PommProject\ModelManager\SessionBuilder as ModelManagerSessionBuilder;
use Psr\Log\LogLevel;

class SessionBuilder extends ModelManagerSessionBuilder
{
    /**
     * @param Session|\PommProject\Foundation\Session $session
     *
     * @return Session|SessionBuilder
     *
     * @throws \PommProject\Foundation\Exception\FoundationException
     */
    protected function postConfigure(Session $session)
    {
        parent::postConfigure($session);

        $session
            ->getListener('query')
            ->attachAction(function($eventName, $data, Session $session) {
                if (!$logger = $session->getLogger()) return;

                if ($eventName === 'query:pre' && isset($data['sql'])) {
                    $logger->debug($data['sql'], [
                        'parameters' => $data['parameters'],
                        'session_stamp' => $data['session_stamp'],
                    ]);
                }
            })
        ;

        $session
            ->getPoolerForType('converter')
            ->getConverterHolder()
            ->addTypeToConverter('Origin', 'tool.origin')
            ->addTypeToConverter('String', 'public.global_id')
            ->addTypeToConverter('String', 'public.partial_date')
            ->addTypeToConverter('Tag3D', 'public.tag3d')
            ->addTypeToConverter('Tag3DArray', 'public.tag3d_array')
        ;

        return $this;
    }

    /**
     * @see SessionBuilder
     */
    protected function initializeConverterHolder(ConverterHolder $converter_holder)
    {
        parent::initializeConverterHolder($converter_holder);

        $converter_holder
            ->registerConverter(
                'Tag3D',
                new Tag3D(),
                ['public.tag3d'],
                false
            )
            ->registerConverter(
                'Tag3DArray',
                new Tag3DArray(),
                ['public.tag3d_array'],
                false
            )
            ->registerConverter(
                'Origin',
                new Origin(),
                ['tool.origin'],
                false
            );

        return $this;
    }
}
