<?php

namespace Allocine\DbzModelBundle\Tests\Model\Social;

use Allocine\DbzModelBundle\Model\Social\UserModel;
use Allocine\DbzModelBundle\Tests\KernelTestCase;

class UserModelTest extends KernelTestCase
{
    /**
     * @todo use data-providers / fixtures
     *
     * @var array
     */
    private $users = [
        [
            'active' => true,
            'origin' => 'CORE',
            'id_brand' => 'AC',
            'id' => 23456789,
            'id_legacy' => 'Z23456789',
            'email' => 'john.smith@allocine.fr',
            'email_decrypted' => 'john.smith@allocine.fr',
            'profile' => '{}',
            'profile_decrypted' => '{}',
            'password' => 'be',
            'salt' => 'er',
            'nickname' => 'John Smith'
        ],
        [
            'active' => true,
            'origin' => 'CORE',
            'id_brand' => 'AC',
            'id' => 234567892,
            'id_legacy' => 'Z22345678',
            'email' => 'lucky.luke@allocine.fr',
            'email_decrypted' => 'lucky.luke@allocine.fr',
            'profile' => '{}',
            'profile_decrypted' => '{}',
            'password' => 'be',
            'salt' => 'er',
            'nickname' => 'Lucky Luke'
        ],
    ];

    protected function setUp()
    {
        parent::setUp();

        foreach ($this->users as $user) {
            $user = $this->getModel()->createAndSave($user);
        }
    }

    /**
     * @return UserModel
     */
    private function getModel()
    {
        return static::$container->get('test.user_model');
    }

    public function testLoadByEmail()
    {
        $user = $this->getModel()->loadByEmail('lucky.luke@allocine.fr', 'AC');

        $this->assertNotNull($user);
        $this->assertSame($user['id'], 234567892);
    }
}
