<?php

namespace AlloCine\BrandBundle\Tests\Model;

use AlloCine\BrandBundle\Model\FolderRepository;
use PHPUnit\Framework\TestCase;

class FolderRepositoryTest extends TestCase
{
    public function testGetTaggedFolders()
    {
        $folders = $this->getRepository()->getTaggedFolders('twig', 'brand1');
        $this->assertSame(['/view/brand1', '/view/default'], $folders);

        $folders = $this->getRepository()->getTaggedFolders('custom', 'brand2');
        $this->assertSame(['/config/brand2/custom'], $folders);
    }

    public function testGetTaggedFoldersDefault()
    {
        $folders = $this->getRepository('brand1')->getTaggedFolders('custom');
        $this->assertSame(['/config/brand1/custom'], $folders);
    }

    public function testGetAllTaggedFolders()
    {
        $folders = $this->getRepository()->getAllTaggedFolders('twig');
        $this->assertSame(['/view/brand1', '/view/brand2', '/view/default'], $folders);

        $folders = $this->getRepository()->getAllTaggedFolders('custom');
        $this->assertSame(['/config/brand1/custom', '/config/brand2/custom'], $folders);
    }

    /**
     * @expectedException \InvalidArgumentException
     * @expectedExceptionMessage No provided brand and no default brand set.
     */
    public function testGetAllTaggedFoldersNoBrand()
    {
        $this->getRepository()->getTaggedFolders('twig');
    }

    /**
     * @param string|null $defaultBrand
     *
     * @return FolderRepository
     */
    private function getRepository($defaultBrand = null)
    {
        $folders = [
            'views' => [
                'path'         => '/view/{brand}',
                'tags'         => ['twig'],
                'commonFolder' => 'default'
            ],
            'custom_config' => [
                'path'         => '/config/{brand}/custom',
                'tags'         => ['custom'],
                'commonFolder' => null,
            ]
        ];

        return new FolderRepository(['brand1', 'brand2'], $folders, $defaultBrand);
    }
}
