<?php

namespace AlloCine\BrandBundle\Tests;

use Symfony\Bundle\FrameworkBundle\Test\WebTestCase as BaseWebTestCase;

abstract class WebTestCase extends BaseWebTestCase
{
    /**
     * @param $name
     *
     * @return object
     *
     * @throws \Exception
     */
    public function get($name)
    {
        if (null === static::$kernel) {
            throw new \Exception(sprintf('You must call static::bootKernel before call "container->get(\'%s\')"', $name));
        }

        return static::$kernel->getContainer()->get($name);
    }

    /**
     * Creates a Kernel.
     *
     * Available options:
     *
     *  * environment
     *  * debug
     *
     * @param array $options An array of options
     *
     * @return Symfony\Component\HttpKernel\KernelInterface A KernelInterface instance
     */
    protected static function createKernel(array $options = [])
    {
        if (null === static::$class) {
            static::$class = static::getKernelClass();
        }

        return new static::$class(
            isset($options['environment']) ? $options['environment'] : 'test',
            isset($options['debug']) ? $options['debug'] : true,
            isset($options['brand']) ? $options['brand'] : null
        );
    }
}
