<?php

namespace AlloCine\BrandBundle\Tools;

use Symfony\Component\Routing\RouteCollection;

/**
 * Set of tools to use with routing
 */
class RoutingTools
{
    /**
     * Remove brand from route
     *
     * @param string $route
     *
     * @return string
     */
    public static function debrand($route)
    {
        $parts = explode('__', $route);
        return count($parts) > 1 ? $parts[1] : $parts[0];
    }

    /**
     * Removes routes from a collection that does not match the given brand.
     *
     * @param RouteCollection $routes
     * @param string          $brand
     *
     * @return RouteCollection
     */
    public static function filterBrand(RouteCollection $routes, $brand)
    {
        $filteredRoutes = new RouteCollection();

        foreach ($routes->all() as $name => $route) {
            $routeBrand = $route->getDefault('_brand');

            if (!$routeBrand || ($routeBrand === $brand)) {
                $filteredRoutes->add($name, $route);
            }
        }

        return $filteredRoutes;
    }
}
