<?php

namespace Tests\BrandBundle\Tests\Routing\Loader;

use AlloCine\BrandBundle\Model\BrandRepository;
use AlloCine\BrandBundle\Routing\Loader\YamlFileLoader;
use Symfony\Component\Config\FileLocator;

class YamlFileLoaderTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @expectedException        Symfony\Component\Config\Exception\FileLoaderLoadException
     * @expectedExceptionMessage Could not find brand "brand2"
     */
    public function testUnknownBrand()
    {
        $this->getLoader(['brand1' => ['host' => 'brand1.fr']])->load('routing.yml');
    }

    private function getLoader(array $brands)
    {
        $repository = new BrandRepository($brands);

        return new YamlFileLoader(new FileLocator(__DIR__ . '/../../Resources'), $repository);
    }
}
