<?php

namespace AlloCine\BrandBundle\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;

/**
 * Class RouterOverridePass
 *
 * This class overrides the default router, and replaces it by the
 * brand router.
 */
class RouterOverridePass implements CompilerPassInterface
{
    /**
     * @inheritdoc
     */
    public function process(ContainerBuilder $container)
    {
        $router = $container->getDefinition('router.default');
        $router->setClass('AlloCine\BrandBundle\Routing\BrandRouter');
        $router->addMethodCall('setDefaultBrand', [$container->getParameter('brand')]);

        foreach ($container->findTaggedServiceIds('brand_router.generator_extension') as $id => $tags) {
            foreach ($tags as $attributes) {
                $router->addMethodCall('addExtension', [ new Reference($id) ]);
            }
        }

        $loader = $container->getDefinition('brand.routing.loader.yml');

        foreach ($container->findTaggedServiceIds('brand_router.loader_extension') as $id => $tags) {
            foreach ($tags as $attributes) {
                $loader->addMethodCall('addExtension', [ new Reference($id) ]);
            }
        }
    }
}
