<?php

namespace AlloCine\BrandBundle\Command;

use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use Symfony\Component\Process\Process;

/**
 * Description of CacheWarmupupAllCommand
 */
class CacheWarmupupAllCommand extends ContainerAwareCommand
{
    /**
     * {@inheritdoc}
     */
    protected function configure()
    {
        $this
            ->setName('cache:warmup:all')
            ->setDefinition([
                new InputOption(
                    'no-optional-warmers',
                    '',
                    InputOption::VALUE_NONE,
                    'Skip optional cache warmers (faster)'
                ),
            ])
            ->setDescription('Warms up an empty cache fro every brands')
            ->setHelp(<<<'EOF'
The <info>%command.name%</info> command warms up the cache.

Before running this command, the cache must be empty.

This command does not generate the classes cache (as when executing this
command, too many classes that should be part of the cache are already loaded
in memory). Use <comment>curl</comment> or any other similar tool to warm up
the classes cache if you want.

EOF);
    }

    /**
     * {@inheritdoc}
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $io = new SymfonyStyle($input, $output);
        $brands = $this->getContainer()->get('brand.brand_repository')->getAvailableBrands();
        $consoleExecutable = $this->getContainer()->getParameter('kernel.project_dir') . '/bin/console';

        foreach ($brands as $brand) {
            $io->title(sprintf('Warming up the cache for the <info>%s</info> brand', $brand));

            $command = [
                $consoleExecutable,
                'cache:warmup',
                '--env',
                $this->getContainer()->get('kernel')->getEnvironment(),
                '--brand',
                $brand,
            ];

            if (true === $input->getOption('no-optional-warmers')) {
                $command[] = '--no-optional-warmers';
            }

            if (true === $input->getOption('no-debug')) {
                $command[] = '--no-debug';
            }

            $process = new Process($command);
            $process->setTimeout(null);

            $process->run(function ($type, $text) use ($output) {
                $output->write($text);
            });

            if (!$process->isSuccessful()) {
                throw new \RuntimeException($process->getErrorOutput());
            }
            $process = null;
            $command = null;
        }
    }
}
